using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Intemi.InTrees
{
    public partial class InTreeView : Form
    {
        //private NodeDataForm nodeForm = new NodeDataForm();
        public InTreeView(Node<DTNode> node)
        {
            InitializeComponent();

            // Suppress repainting the TreeView until all the objects have been created.
            treeView1.BeginUpdate();

            // Clear the TreeView each time the method is called.
            treeView1.Nodes.Clear();

            TreeNode rootTreeNode = new TreeNode("root");
            treeView1.Nodes.Add(rootTreeNode);

            BuildTreeView(node, rootTreeNode);

            treeView1.EndUpdate();

            IEnumerator<DTNode> enume = node.GetBreadthFirstEnumerator();
            while (enume.MoveNext())
            {

                //Console.WriteLine(enume.Current);
            }

            //nodeForm.Show();

        }

        private void BuildTreeView(Node<DTNode> node, TreeNode treeNode)
        {
  
            TreeNode newTreeNode = new TreeNode(node.Data.ToString());
            newTreeNode.ForeColor = Color.Blue;

            //TreeNode a = new TreeNode(
            if (node.Data.Rule != null) //dla roota nie ma reguly prowadzacej do niego
            {
               TreeNode ruleNode = new TreeNode(node.Data.Rule.ToString());
               ruleNode.Expand();
               ruleNode.Nodes.Add(newTreeNode);
               newTreeNode.Tag = node.Data;
               treeNode.Nodes.Add(ruleNode);
            }
            else
            {
               newTreeNode.Tag = node.Data;
               treeNode.Nodes.Add(newTreeNode);
            }
         
            foreach (Node<DTNode> node2 in node.Children)
            {
                BuildTreeView(node2, newTreeNode);
            }
        }

        private void treeView1_DoubleClick(object sender, EventArgs e)
        {
            DTNode dtNode = treeView1.SelectedNode.Tag as DTNode;

            if (dtNode != null)
            {
                if (dtNode.InstanceCount == -1)
                {
                    MessageBox.Show("Z Machineem drzewa nie s powizane adne dane!");
                }
                else
                {
                    NodeDataForm nodeForm = new NodeDataForm();
                    nodeForm.Init(dtNode);
                    nodeForm.Show();
                }
            }
        }      
    }
}